﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class FindInFilesPanel
    Inherits FileSystemSample.TaskPanelBase

#Region " Windows 窗体设计器生成的代码 "

    Public Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub
    Friend WithEvents BackgroundWorker1 As System.ComponentModel.BackgroundWorker
    Friend WithEvents FilesListBox As System.Windows.Forms.ListBox

    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        Me.BackgroundWorker1 = New System.ComponentModel.BackgroundWorker
        Me.FilesListBox = New System.Windows.Forms.ListBox
        Me.GroupBox2.SuspendLayout()
        Me.SuspendLayout()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.AutoSize = False
        Me.DescriptionTextBox.Multiline = True
        Me.DescriptionTextBox.Size = New System.Drawing.Size(568, 31)
        Me.DescriptionTextBox.Text = "This sample searches a collection of files for the text specified.  Widcards may " & _
            "be used to select a subset of all files in a directory."
        '
        'ExececuteMethodButton
        '
        '
        'ResetValuesButton
        '
        '
        'GroupBox2
        '
        Me.GroupBox2.Controls.Add(Me.FilesListBox)
        Me.GroupBox2.Controls.SetChildIndex(Me.EndParenLabel, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ExececuteMethodButton, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.ResetValuesButton, 0)
        Me.GroupBox2.Controls.SetChildIndex(Me.FilesListBox, 0)
        '
        'BackgroundWorker1
        '
        Me.BackgroundWorker1.WorkerReportsProgress = False
        Me.BackgroundWorker1.WorkerSupportsCancellation = False
        '
        'FilesListBox
        '
        Me.FilesListBox.FormattingEnabled = True
        Me.FilesListBox.Location = New System.Drawing.Point(14, 261)
        Me.FilesListBox.Name = "FilesListBox"
        Me.FilesListBox.Size = New System.Drawing.Size(559, 108)
        Me.FilesListBox.TabIndex = 5
        '
        'FindInFilesPanel
        '
        Me.Name = "FindInFilesPanel"
        Me.GroupBox2.ResumeLayout(False)
        Me.GroupBox2.PerformLayout()
        Me.ResumeLayout(False)

    End Sub

#End Region


    Private Shared panelInstance As FindInFilesPanel
    Friend WithEvents dirChooser As New DirectoryChooser()
    Friend WithEvents searchTextBox As New TextBox()
    Friend WithEvents recurseComboBox As New ComboBox()
    Friend WithEvents wildCardsComboBox As New ComboBox()

    Private searchResults As System.Collections.ObjectModel.ReadOnlyCollection(Of String)
    Private searchText As String
    Private directory As String
    Private recurse As Boolean
    Private wildCards As String()

    ''' <summary>
    ''' 获取该面板的全局实例。
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As FindInFilesPanel
        If (panelInstance Is Nothing) Then
            panelInstance = New FindInFilesPanel
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 加载该面板，并添加所需的控件。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub FindInFiles_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        Me.dirChooser.Reset()
        MyBase.AddParameter("directory", dirChooser)
        MyBase.AddParameter("searchText", searchTextBox)
        MyBase.AddParameter("recurse", recurseComboBox)
        MyBase.AddParameter("wildCards", wildCardsComboBox)
    End Sub


    ''' <summary>
    ''' 将该面板重置为其默认状态。
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.FindInFiles("
        Me.dirChooser.Reset()

        recurseComboBox.Items.AddRange(New String() {"True", "False"})
        recurseComboBox.AutoSize = True
        recurseComboBox.SelectedItem = "False"

        wildCardsComboBox.Items.AddRange(New String() {"*.*", "*.txt", "*.doc", "*.vb", "*.bmp", ".jpg"})
        wildCardsComboBox.AutoSize = True
        wildCardsComboBox.SelectedItem = "*.*"
    End Sub


    ''' <summary>
    ''' 现在在所有指定的文件中搜索文本。这不是 My.Computer.FileSystem 直接支持的方法。
    ''' 因此需要在此处编写逻辑。因为此操作具有延时性，所以将使用 BackgroundWorker
    ''' 异步执行此搜索。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        If Not Me.BackgroundWorker1.IsBusy Then
            Me.FilesListBox.Items.Clear()

            directory = Me.dirChooser.Directory
            searchText = Me.searchTextBox.Text

            recurse = Boolean.Parse(CType(Me.recurseComboBox.SelectedItem, String))
            wildCards = New String() {CType(Me.wildCardsComboBox.SelectedItem, String)}

            Me.BackgroundWorker1.WorkerReportsProgress = True
            Me.BackgroundWorker1.RunWorkerAsync()
        End If
    End Sub


    ''' <summary>
    ''' 将该面板及其控件重置为它们的默认状态。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ResetValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub

    ''' <summary>
    ''' 在指定的各个文件中搜索所提供的文本。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub BackgroundWorker1_DoWork(ByVal sender As Object, ByVal e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker1.DoWork
        Dim files As System.Collections.ObjectModel.ReadOnlyCollection(Of String)
            ' 在与所提供的通配符匹配的各个文件中查找
            If (recurse) Then
            files = My.Computer.FileSystem.FindInFiles(directory, searchText, True, FileIO.SearchOption.SearchAllSubDirectories, wildCards)
        Else
            files = My.Computer.FileSystem.FindInFiles(directory, searchText, True, FileIO.SearchOption.SearchTopLevelOnly, wildCards)
            End If
        For Each foundFile As String In files
            Me.BackgroundWorker1.ReportProgress(0, foundFile)
        Next
    End Sub

    ''' <summary>
    ''' 将找到的文件添加到 ListBox 中
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub BackgroundWorker1_ProgressChanged(ByVal sender As Object, ByVal e As System.ComponentModel.ProgressChangedEventArgs) Handles BackgroundWorker1.ProgressChanged
        Me.FilesListBox.Items.Add(CType(e.UserState, String))
    End Sub

    ''' <summary>
    ''' 该搜索已完成。如果未找到结果，则在列表框中显示一条消息。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub BackgroundWorker1_RunWorkerCompleted(ByVal sender As Object, ByVal e As System.ComponentModel.RunWorkerCompletedEventArgs) Handles BackgroundWorker1.RunWorkerCompleted
        If Me.FilesListBox.Items.Count < 1 Then
            Me.FilesListBox.Items.Add("No files with the specified text found.")
        End If
    End Sub

End Class
